/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.Dialog;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.KeyMap;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.UserPreferences;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.CharBuffer;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

class ServerDialog
extends Dialog
implements Runnable {
    Dialog.MyJComboBox serverName;
    ComboBoxEditor editor;
    JButton aboutButton;
    JButton optionsButton;
    JButton connectButton;
    JButton cancelButton;
    OptionsDialog options;
    CharBuffer vncServerName;
    static LogWriter vlog = new LogWriter("ServerDialog");

    public ServerDialog(String string, CharBuffer charBuffer) {
        super(true);
        String string2;
        this.vncServerName = charBuffer;
        this.setDefaultCloseOperation(0);
        this.setTitle("TigerVNC");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ServerDialog.this.endDialog();
                System.exit(1);
            }
        });
        JLabel jLabel = new JLabel("VNC server:", 4);
        String string3 = new String(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string3.isEmpty()) {
            arrayList.add(string3);
        }
        if ((string2 = UserPreferences.get("ServerDialog", "history")) != null) {
            for (String object2 : string2.split(",")) {
                if (arrayList.indexOf(object2) >= 0) continue;
                arrayList.add(object2);
            }
        }
        this.serverName = new Dialog.MyJComboBox(arrayList.toArray());
        this.serverName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (actionEvent.getActionCommand().equals("comboBoxEdited")) {
                    jComboBox.insertItemAt(ServerDialog.this.editor.getItem(), 0);
                    jComboBox.setSelectedIndex(0);
                }
            }
        });
        if (arrayList.size() == 0) {
            this.serverName.setPrototypeDisplayValue("255.255.255.255:5900");
        }
        this.serverName.setEditable(true);
        this.editor = this.serverName.getEditor();
        this.editor.getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (KeyMap.get_keycode_fallback_extended(keyEvent) == 10) {
                    ServerDialog.this.serverName.insertItemAt(ServerDialog.this.editor.getItem(), 0);
                    ServerDialog.this.serverName.setSelectedIndex(0);
                    ServerDialog.this.handleConnect();
                }
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JLabel jLabel2 = new JLabel(VncViewer.logoIcon);
        this.optionsButton = new JButton("Options...");
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.handleOptions();
            }
        });
        JButton jButton = new JButton("Load...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.handleLoad();
            }
        });
        JButton jButton2 = new JButton("Save As...");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.handleSaveAs();
            }
        });
        this.aboutButton = new JButton("About...");
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.handleAbout();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.handleCancel();
            }
        });
        this.connectButton = new JButton("Connect   \u21b5");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.handleConnect();
            }
        });
        container.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        container.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 10, 5, 5), 0, 0));
        container.add((Component)this.serverName, new GridBagConstraints(2, 0, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(5, 0, 5, 5), 0, 0));
        JPanel jPanel = new JPanel();
        Box box = Box.createHorizontalBox();
        JSeparator jSeparator = new JSeparator();
        JSeparator jSeparator2 = new JSeparator();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(false);
        groupLayout.setAutoCreateContainerGaps(false);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.optionsButton)).addComponent(jSeparator).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.aboutButton))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(box).addGap(10)).addComponent(jSeparator2).addGroup(groupLayout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectButton).addGap(10))));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsButton).addComponent(jButton).addComponent(jButton2).addComponent(box)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jSeparator).addComponent(jSeparator2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aboutButton).addComponent(this.cancelButton).addComponent(this.connectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED));
        groupLayout.linkSize(0, this.optionsButton, jButton, jButton2, this.aboutButton, this.cancelButton, box);
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(5, 0, 10, 0), 0, 0));
        this.pack();
    }

    @Override
    public void run() {
        this.showDialog();
    }

    private void handleOptions() {
        if (VncViewer.os.startsWith("mac os x")) {
            this.setAlwaysOnTop(false);
        }
        OptionsDialog.showDialog(this);
    }

    private void handleLoad() {
        FileNameExtensionFilter fileNameExtensionFilter;
        String string = "Select a TigerVNC configuration file";
        File file = new File(FileUtils.getVncConfigDir().concat("default.tigervnc"));
        File file2 = this.showChooser(string, file, fileNameExtensionFilter = new FileNameExtensionFilter("TigerVNC configuration (*.tigervnc)", "tigervnc"));
        if (file2 != null && file2.exists() && file2.canRead()) {
            Parameters.loadViewerParameters(file2.getAbsolutePath());
        }
    }

    private void handleSaveAs() {
        String string = "Save the TigerVNC configuration to file";
        File file = new File(FileUtils.getVncConfigDir().concat("default.tigervnc"));
        if (!file.exists() || !file.isFile()) {
            file = new File(FileUtils.getVncConfigDir());
        }
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("TigerVNC configuration (*.tigervnc)", "tigervnc");
        File file2 = this.showChooser(string, file, fileNameExtensionFilter);
        while (file2 != null && file2.exists() && file2.isFile()) {
            String string2 = file2.getAbsolutePath();
            string2 = string2.concat(" already exists. Do you want to overwrite?");
            Object[] objectArray = new Object[]{"Overwrite", "No  \u21b5"};
            JOptionPane jOptionPane = new JOptionPane(string2, 3, 2, null, objectArray, objectArray[1]);
            JDialog jDialog = jOptionPane.createDialog(this, "TigerVNC");
            jDialog.setIconImage(VncViewer.frameIcon);
            jDialog.setAlwaysOnTop(true);
            jDialog.setVisible(true);
            if (jOptionPane.getValue() == objectArray[0]) break;
            file2 = this.showChooser(string, file2, fileNameExtensionFilter);
        }
        if (file2 != null && (!file2.exists() || file2.canWrite())) {
            Parameters.saveViewerParameters(file2.getAbsolutePath(), (String)this.serverName.getSelectedItem());
        }
    }

    private void handleAbout() {
        VncViewer.about_vncviewer(this);
    }

    private void handleCancel() {
        this.endDialog();
    }

    private void handleConnect() {
        String string = (String)this.serverName.getSelectedItem();
        string.trim();
        this.vncServerName.put(string).flip();
        Parameters.saveViewerParameters(null, string);
        this.endDialog();
    }
}

